import Link from 'next/link'
import { Phone, Mail, MapPin, Clock } from 'lucide-react'
import { Separator } from '@/components/ui/separator'

export default function Footer() {
  return (
    <footer className="bg-gray-900 text-white">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Company Info */}
          <div>
            <div className="flex items-center space-x-3 mb-6">
              <div className="bg-blue-600 text-white px-3 py-2 rounded-lg font-bold text-xl">
                SAAM
              </div>
              <div className="text-xl font-bold">CABINS</div>
            </div>
            <p className="text-gray-400 mb-4">
              Leading porta cabin manufacturer and supplier in UAE. We provide innovative, 
              customized solutions for all your portable building needs.
            </p>
            <p className="text-sm text-gray-500">
              Manufacturing facility based in Sharjah with UAE-wide delivery.
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="text-lg font-semibold mb-4">Quick Links</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/" className="text-gray-400 hover:text-white transition-colors">
                  Home
                </Link>
              </li>
              <li>
                <Link href="/about" className="text-gray-400 hover:text-white transition-colors">
                  About Us
                </Link>
              </li>
              <li>
                <Link href="/work" className="text-gray-400 hover:text-white transition-colors">
                  Our Work
                </Link>
              </li>
              <li>
                <Link href="/contact" className="text-gray-400 hover:text-white transition-colors">
                  Contact
                </Link>
              </li>
            </ul>
          </div>

          {/* Products */}
          <div>
            <h3 className="text-lg font-semibold mb-4">Our Products</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/products/office-cabin" className="text-gray-400 hover:text-white transition-colors">
                  Office Porta Cabin
                </Link>
              </li>
              <li>
                <Link href="/products/security-cabin" className="text-gray-400 hover:text-white transition-colors">
                  Security Cabin
                </Link>
              </li>
              <li>
                <Link href="/products/toilet-units" className="text-gray-400 hover:text-white transition-colors">
                  Toilet Units
                </Link>
              </li>
              <li>
                <Link href="/products/custom" className="text-gray-400 hover:text-white transition-colors">
                  Custom Solutions
                </Link>
              </li>
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h3 className="text-lg font-semibold mb-4">Contact Info</h3>
            <div className="space-y-3">
              <div className="flex items-start space-x-3">
                <MapPin className="h-5 w-5 text-blue-400 mt-0.5" />
                <div className="text-gray-400 text-sm">
                  <div>P2 Hamriyah</div>
                  <div>Sharjah, UAE</div>
                  <div>Post Box: 662</div>
                </div>
              </div>
              <div className="flex items-center space-x-3">
                <Phone className="h-5 w-5 text-blue-400" />
                <div className="text-gray-400 text-sm">
                  <div>+971 58 201 2073</div>
                  <div>+971 6 714 4832</div>
                </div>
              </div>
              <div className="flex items-center space-x-3">
                <Mail className="h-5 w-5 text-blue-400" />
                <a href="mailto:sales@saamcabins.com" className="text-gray-400 text-sm hover:text-white">
                  sales@saamcabins.com
                </a>
              </div>
              <div className="flex items-center space-x-3">
                <Clock className="h-5 w-5 text-blue-400" />
                <div className="text-gray-400 text-sm">
                  Quick delivery within few days
                </div>
              </div>
            </div>
          </div>
        </div>

        <Separator className="my-8 bg-gray-800" />

        {/* Bottom Bar */}
        <div className="flex flex-col md:flex-row justify-between items-center">
          <div className="text-gray-400 text-sm">
            Copyright ©2025 All rights reserved | SAAM Cabins
          </div>
          <div className="text-gray-400 text-sm mt-4 md:mt-0">
            Porta Cabin Solutions | Manufacturing & Supply across UAE
          </div>
        </div>
      </div>
    </footer>
  )
}